#ifndef MOTIONCONTROL_H_
#define MOTIONCONTROL_H_

/* Includes ------------------------------------------------------------------*/
#include "stm32f10x_conf.h"
#include "Coordinate.h"
#include "Robot.h"

/* Exported types ------------------------------------------------------------*/
typedef enum
{
    MOTIONCONTROL_Setup,
    MOTIONCONTROL_Configuring,
    MOTIONCONTROL_Running,
    MOTIONCONTROL_Alarm

} MotionControl_State;

/* Exported function prototypes ----------------------------------------------*/

// MotionControl_Init()
// --------------------
// Initialize the motion control module.
extern void MotionControl_Init();

// MotionControl_BeginCalibration()
// --------------------------------
// Start the continuous reading of the ADC values from the servo calibration trimpots.
#define MotionControl_BeginCalibration() (Robot_BeginCalibration())

// MotionControl_UpdateCalibration()
// ---------------------------------
// Sets all servos to a known angle so that the servo calibration parameters can
// be correctly adjusted.
#define MotionControl_UpdateCalibration() (Robot_UpdateCalibration())

// MotionControl_EndCalibration()
// ------------------------------
// Stop the ADC conversions and leave the servo calibration parameters in a fixed state.
#define MotionControl_EndCalibration() (Robot_EndCalibration())

// MotionControl_SetState()
// ------------------------
// Set the current state of the robot.
extern void MotionControl_SetState(MotionControl_State state);

// MotionControl_OnSecond()
// ------------------------
// Handle the one second interrupt.
extern void MotionControl_OnSecond(uint16_t seconds);

// MotionControl_OnAlarm()
// -----------------------
// Handle the alarm interrupt.
extern void MotionControl_OnAlarm();

#endif /* MOTIONCONTROL_H_ */
